/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.client.render.item.WoodChipRenderer;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTags;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.registries.ForgeRegistries;

public class WoodChip
extends Item {
    protected static final String KEY = "productivebees_woodtype";

    public WoodChip(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack getStack(Block block) {
        return WoodChip.getStack(block, 1);
    }

    public static ItemStack getStack(Block block, int count) {
        return WoodChip.getStack(block.getRegistryName().toString(), count);
    }

    public static ItemStack getStack(String blockName, int count) {
        ItemStack result = new ItemStack((ItemLike)ModItems.WOOD_CHIP.get(), count);
        WoodChip.setBlock(result, blockName);
        return result;
    }

    public static void setBlock(ItemStack stack, String blockName) {
        stack.m_41784_().m_128359_(KEY, blockName);
    }

    @Nullable
    public static Block getBlock(ItemStack stack) {
        String blockType = WoodChip.getBlockType(stack);
        if (blockType != null && !blockType.isEmpty()) {
            return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockType));
        }
        return null;
    }

    public static String getBlockType(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128461_(KEY) : null;
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        Block block = WoodChip.getBlock(stack);
        if (block != null) {
            return new TranslatableComponent(this.m_5524_() + ".named", new Object[]{new TranslatableComponent(block.m_7705_())});
        }
        return super.m_7626_(stack);
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            try {
                Registry.f_122824_.m_206058_(ModTags.LUMBER).forEach(blockHolder -> {
                    Block block = (Block)blockHolder.m_203334_();
                    if (block.getRegistryName() != null && block.getRegistryName().m_135815_().contains("log")) {
                        items.add((Object)WoodChip.getStack(block));
                    }
                });
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){
            final BlockEntityWithoutLevelRenderer myRenderer = new WoodChipRenderer();

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return this.myRenderer;
            }
        });
    }

    public static ShapelessRecipe getRecipe(Block b) {
        ItemStack chip = WoodChip.getStack(b);
        String[] id = b.getRegistryName().toString().split(":");
        NonNullList list = NonNullList.m_122779_();
        for (int i = 0; i < 9; ++i) {
            Ingredient ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{chip});
            if (ingredient.m_43947_()) continue;
            list.add((Object)ingredient);
        }
        return new ShapelessRecipe(new ResourceLocation("productivebees", "wood_chip_" + id[1]), "", new ItemStack((ItemLike)b.m_5456_()), list);
    }
}

